import 'package:admin_desktop/infrastructure/services/tr_keys.dart' show TrKeys;
import 'package:admin_desktop/presentation/components/buttons/custom_button.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import '../../../infrastructure/services/app_helpers.dart';

class DeleteDialog extends StatelessWidget {
  final String? title;
  final VoidCallback success;

  const DeleteDialog({super.key, this.title, required this.success});

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.all(16.0),
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          Text(
            AppHelpers.getTranslation(title ?? TrKeys.areYouSure),
            style: Style.interNormal(),
            textAlign: TextAlign.center,
          ),
          30.verticalSpace,
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            mainAxisSize: MainAxisSize.min,
            children: [
              CustomButton(
                height: 48,
                width: 108,
                borderColor:Style.black,
                textColor: Style.black,
                bgColor:Style.transparent,
                title: AppHelpers.getTranslation(TrKeys.no),
                onTap: () {
                  Navigator.pop(context);
                },
              ),
              10.horizontalSpace,
              CustomButton(
                height: 48,
                width: 108,
                textColor: Style.white,
                title: AppHelpers.getTranslation(TrKeys.yes),
                onTap: success,
                bgColor: Style.red,
              ),
            ],
          ),
        ],
      ),
    );
  }
}
